int imin = 0;
int imax = 3;

String LEDLabel[3] = { "b472:", "v523:", "r637:" };
int PinLEDRVB[3] = { 8, 9, 10 };  // Numéro des pins Alimentation de la LED RVB
int Tstab = 15;                   // temps d'attente pour stabilisation de la LED entre état allumé et eteint

int PinPhotoDiode = A0;  // Numéro du pin signal photodiode

int Lectures = 50;
float Son[3];      // Signal proportionnel à l'intensité reçue LED allumée
float Soff;        // Signal proportionnel à l'intensité reçue LED éteinte (fond parasite)
float Smesure[3];  // Smesure= Son-Soff pour s'affranchir du fond parasite

float S0[3] = { 0.0, 0.0, 0.0 };  // Signal blanc, valeur initiale arbitraire
float alpha = 0.05;                // pour calculer la moyenne exponentielle
float A[3];                       // Absorbance=-log10(Smesure/S0)


int TempsEntreAffichage = 1000;
float TempsAffichageSuivant;
String chaineSaisie;
boolean Bavard = false;
boolean Abs = true;
boolean Ionly = false;

//--------------------------------------------------------------------------------------------
void setup() {
  Serial.begin(9600);  // Communication avec le moniteur série
  pinMode(PinLEDRVB[0], OUTPUT);
  pinMode(PinLEDRVB[1], OUTPUT);
  pinMode(PinLEDRVB[2], OUTPUT);
  pinMode(PinPhotoDiode, INPUT);  // Définition pin connecté à la photodiode

  TempsAffichageSuivant = millis() + TempsEntreAffichage;
}
//--------------------------------------------------------------------------------------------
void loop() {

  for (int i = imin; i < imax; i++) {
    digitalWrite(PinLEDRVB[i], HIGH);
    delay(Tstab);
    Son[i] = 1.0 * analogRead(PinPhotoDiode);
    for (int j = 1; j <= Lectures; j++) {
      Son[i] = Son[i] + analogRead(PinPhotoDiode);
    }
    Son[i] = Son[i] / (Lectures + 1);
    digitalWrite(PinLEDRVB[i], LOW);
  }
  delay(Tstab);
  Soff = 1.0 * analogRead(PinPhotoDiode);
  for (int i = 1; i <= Lectures; i++) {
    Soff = Soff + analogRead(PinPhotoDiode);
  }
  Soff = Soff / (Lectures + 1);



  for (int i = imin; i < imax; i++) {
    Smesure[i] = alpha * (Son[i] - Soff) + (1 - alpha) * Smesure[i];
    A[i] = log10(S0[i] / Smesure[i]);
  }



  if (millis() > TempsAffichageSuivant) {  // Test pour affichage puis frappe clavier

    if (Bavard) {
      Serial.print(Soff);
      Serial.print(" =off    on= ");
      for (int i = imin; i < imax; i++) {
        Serial.print(Son[i]);
        Serial.print(">");
        Serial.print(Son[i] - Soff);
        Serial.print("/");
        Serial.print(S0[i]);
        Serial.print("  ");
      }
      Serial.print("         ");
    }

    if (Abs) {
      //Serial.print("Abs   ");
      for (int i = imin; i < imax; i++) {
        //Serial.print(LEDLabel[i]);
        Serial.print(A[i], 3);
        if (i != imax - 1) {
          Serial.print(",");
        }
      }
    }

    if (Ionly) {
      //Serial.print("Intenisté Son-Soff    ");
      for (int i = imin; i < imax; i++) {
        //Serial.print(LEDLabel[i]);
        Serial.print(Son[i] - Soff, 1);
        if (i != imax - 1) {
          Serial.print(",");
        }
      }
    }



    Serial.println("  ");

    if (Serial.available()) { TraiteChaineSaisie(); }

    if (millis() < 5000) {
      for (int i = imin; i < imax; i++) {
        S0[i] = Smesure[i];
      }
    }

    TempsAffichageSuivant = TempsAffichageSuivant + TempsEntreAffichage;
  }  // fin test Affichage


}